<?php
require_once '../../../init.php';
require_once '../../../includes/gatewayfunctions.php';
require_once '../../../includes/invoicefunctions.php';

$gatewayModuleName = 'umvapay';
$gatewayParams = getGatewayVariables($gatewayModuleName);

if (!$gatewayParams['type']) {
    die("Module Not Activated");
}

$status = $_POST['status'] ?? null;
$signature = $_POST['signature'] ?? null;
$identifier = $_POST['identifier'] ?? null;
$data = $_POST['data'] ?? [];

$invoiceId = $_GET['invoiceid'] ?? $identifier ?? null;
$amount = $data['amount'] ?? null;
$secret = $gatewayParams['secret_key'];
$expectedSignature = strtoupper(hash_hmac('sha256', $amount . $identifier, 
$secret));

if (!$invoiceId || !$status || !$signature || !$identifier || !$amount) {
    logTransaction($gatewayParams['name'], $_POST, "Missing required 
fields");
    http_response_code(400);
    exit("Bad Request");
}

if ($signature !== $expectedSignature || $identifier !== 
$gatewayParams['public_key']) {
    logTransaction($gatewayParams['name'], $_POST, "Invalid signature or 
identifier");
    http_response_code(403);
    exit("Invalid Signature");
}

$invoiceId = checkCbInvoiceID($invoiceId, $gatewayParams['name']);
$transactionId = $_POST['txn_id'] ?? uniqid('txn_');
checkCbTransID($transactionId);

if (strtolower($status) === 'success') {
    addInvoicePayment($invoiceId, $transactionId, '', '', 
$gatewayModuleName);
    logTransaction($gatewayParams['name'], $_POST, "Payment Successful");
    echo "OK";
} else {
    logTransaction($gatewayParams['name'], $_POST, "Payment Failed");
    http_response_code(400);
    echo "FAILED";
}
